package cve;
import java.util.*;
import ve.*;

/**
 * A ContextualBeliefNetwork contains a tuple of {@link Variable}s
 * (each with a domain) and a set of generalised rules (of the form
 * {@link GenRule}).

 * @author David Poole
 * @version 0.1 2001-05-22
 **/
public class ContextualBeliefNetwork {

    protected RuleCollection rules;
    protected Variable[] variables;
    protected int numVariables;
    protected final static int maxDomainSize=100;
    protected final static int maxFactorSize=30;
    protected final static int maxContextSize=30;

    public RuleCollection getRules() {
	return rules;
    }
    public Variable[] getVariables() {
	return variables;
    }
    public int getNumVariables() {
	return numVariables;
    }

    /** maps the string name to the variable. */
    protected Hashtable stringToVar;

    /** returns the map from the string name to the variable. */
    public Hashtable getStringToVar() {
	return stringToVar;
    }

    /**
     * dummy constructor. Does nothing.
     **/
    ContextualBeliefNetwork() {
    }

    /**
     * constructs a contextual belief network from a beleif network.
     **/
    ContextualBeliefNetwork(DecisionNetwork bn, double accept_threshold) {
	rules = new RuleCollectionFromBeliefNetwork(bn, 0.0, accept_threshold);
	variables = bn.getVariables();
	numVariables = bn.getNumVariables();
	stringToVar = bn.getStringToVar();
    }
    /**
     * constructs a contextual belief network from a beleif network with the approximation given by threshold.
     **/
    ContextualBeliefNetwork(DecisionNetwork bn, double threshold, double accept_threshold) {
	rules = new RuleCollectionFromBeliefNetwork(bn, threshold, accept_threshold);
	variables = bn.getVariables();
	numVariables = bn.getNumVariables();
	stringToVar = bn.getStringToVar();
    }
    
    /**
     * add a new rule to the contextual belief network
     **/
    public void add(GenRule rule) {
	rules.add(rule);
    }

    /**
     * prints the contextual belief network
     **/
    public void print() {
	rules.print();
    }

    /**
     * prints a summary of the contextual belief network
     **/
    public void printBrief() {
	rules.printBrief();
    }

    /**
     * returns the number of variables that appear in splits.  This is
     * fewer than the number of splits as there can be some variables
     * in more than one split.
     **/
    public int getNumSplitVars() {
	RuleIterator ruleItr = rules.iterator();
	Variable[] vars = new Variable[0];
	while (ruleItr.hasNext()) {
	    GenRule nextRule =  ruleItr.next();
	    Variable[] conVars=nextRule.getContext().getVars();
	    if (conVars.length>0) {
		vars=CoveringRuleCollection.unionVariableArrays(vars,conVars);
	    }
	}
	return vars.length;
    }
}


