package cve;
import ve.*;

/**
 * A Belief network constructed from a well formed
 * ContextualBeliefNetwork. Each rule is "for" a single variable, and
 * for each variable, each context is disjoint.


 * @author David Poole
 * @version 0.1 2001-05-08
 **/
public class BeliefNetworkFromThreshold extends DecisionNetwork {
    BeliefNetworkFromThreshold(DecisionNetwork bn, double threshold) {
	super(bn.getVariables(),bn.getNumVariables());
	//Factor orgProbFactors = bn.getProbFactors();
	numProbFactors = bn.getNumProbFactors();
	probFactors = new Factor[numProbFactors];
	for (int i=numProbFactors-1; i >= 0; i--) {
	    Variable[] factorFor = {bn.getVariables()[i]};
	    Factor currFactor = bn.getProbFactors()[i];
	    int currFactorSize = currFactor.getVariables().length;
	    Variable[] redundantVars = new Variable[currFactorSize];
	    int numRedundantVars=0;

	    for (int j=0; j<currFactorSize; j++) {
		if (currFactor.getVariables()[j] != factorFor[0] &&
		    currFactor.isRedundant(currFactor.getVariables()[j], threshold)) {
		    redundantVars[numRedundantVars++]=currFactor.getVariables()[j];
		}
	    }
	    if (numRedundantVars > 0) {
		Variable[] reds = new Variable[numRedundantVars];
		int[] vals = new int[numRedundantVars];
		for (int j=0; j<numRedundantVars; j++) {
		    reds[j]=redundantVars[j];
		    vals[j]=0;
		}
		currFactor = new FactorObserved(currFactor, reds, vals);
	    }

	    probFactors[i]=currFactor;
	}
    }
}
