package cve;
import ve.*;

/**
 * A Belief network constructed from a well formed
 * ContextualBeliefNetwork. Each rule is "for" a single variable, and
 * for each variable, each context is disjoint.


 * @author David Poole
 * @version 0.1 2001-05-08
 **/
public class BeliefNetFromCBN extends BeliefNetwork {

    BeliefNetFromCBN(ContextualBeliefNetwork cbn) {
	super(cbn.getVariables(),cbn.getNumVariables());
	if (cbn.getNumVariables() <= 0) {
	    return;
	}
	// Determine the variables for each factor
	Variable[][] factorVars = new Variable[cbn.getNumVariables()][];
	//int[] factorSize = new int[cbn.getNumVariables()];
        // create a mapping from VarId to position in the array.
	int[] varIdToPos = new int[cbn.getVariables()[cbn.getNumVariables()-1].getId()+1];
	for (int i=0;i<cbn.getNumVariables();i++) {
	    varIdToPos[cbn.getVariables()[i].getId()]=i;
	    factorVars[i]=new Variable[0];
	}
	RuleIterator ruleItr = cbn.getRules().iterator();
	while (ruleItr.hasNext()) {
	    GenRule rule=ruleItr.next();
	    // we should perhaps check for exception in the following
	    int ruleForPos = varIdToPos[rule.getRulesFor()[0].getId()];
	    factorVars[ruleForPos] =
		merge3VarLists(factorVars[ruleForPos],rule.getContext().getVars(),rule.getFactor().getVariables(),cbn.getNumVariables());
	}
	// 
	FactorUpdatable[] factors = new FactorUpdatable[cbn.getNumVariables()];
	for (int i=0;i<cbn.getNumVariables();i++) {
	    factors[i]=new FactorUpdatable(factorVars[i]);
	}
	ruleItr = cbn.getRules().iterator();
	while (ruleItr.hasNext()) {
	    GenRule rule=ruleItr.next();
	    int ruleForPos = varIdToPos[rule.getRulesFor()[0].getId()];
	    factors[ruleForPos].update(rule);
	}
	this.probFactors=factors;
	this.numProbFactors=factors.length;
    }
    
    /**
     * merges three varlists, the last two of which are known to be disjoint.
     **/
    private Variable[] merge3VarLists(Variable[] lst1,Variable[] lst2,Variable[] lst3, int maxSize) {
	//System.out.println("merging: "+stringinfyVarArray(lst1)+" "+stringinfyVarArray(lst2)+" "+stringinfyVarArray(lst3)+":");
	Variable[] result = new Variable[maxSize];
	int pos1=0;
	int pos2=0;
	int pos3=0;
	int posres=0;
	while (pos1<lst1.length && pos2<lst2.length && pos3<lst3.length) {
	    if (lst2[pos2].getId() < lst3[pos3].getId() ) {
		if (lst1[pos1]==lst2[pos2]) {
		    result[posres++]=lst1[pos1++];
		    pos2++;
		}
		else if (lst1[pos1].getId()< lst2[pos2].getId()) {
		    result[posres++]=lst1[pos1++];
		}
		else {  //(lst1[pos1].getId() > lst2[pos2].getId())
		    result[posres++]=lst2[pos2++];
		}
	    }
	    else { // (lst2[pos2].getId() > lst3[pos3].getId() )
		if (lst1[pos1]==lst3[pos3]) {
		    result[posres++]=lst1[pos1++];
		    pos3++;
		}
		else if (lst1[pos1].getId()< lst3[pos3].getId()) {
		    result[posres++]=lst1[pos1++];
		}
		else {  //(lst1[pos1].getId() > lst3[pos3].getId())
		    result[posres++]=lst3[pos3++];
		}
	    }
	}
	// one of the lists is empty
	// make lst1 & lst2 the non empty lists
	if (pos3 < lst3.length) {
	    // list 3 is not empty, it has to replace an empty one
	    if (pos1 == lst1.length) {  // list 1 is empty
		lst1=lst3;
		pos1=pos3;
	    }
	    else {  // list 2 must be the empty one
		lst2=lst3;
		pos2=pos3;
	    }
	}
	while (pos1<lst1.length && pos2<lst2.length) {
	    if (lst1[pos1]==lst2[pos2]) {
		result[posres++]=lst1[pos1++];
		pos2++;
	    }
	    else if (lst1[pos1].getId()< lst2[pos2].getId()) {
		result[posres++]=lst1[pos1++];
	    }
	    else {  //(lst1[pos1].getId() > lst2[pos2].getId())
		result[posres++]=lst2[pos2++];
	    }
	}
	// make lst1 the non-empty list
	if (pos2<lst2.length) {
	    lst1=lst2;
	    pos1=pos2;
	}
	Variable[] finalResult = new Variable[posres+lst1.length-pos1];
	int posfin=0;
	while (posfin<posres) {
	    finalResult[posfin]=result[posfin++];
	}
	while (pos1 < lst1.length) {
	    finalResult[posfin++]=lst1[pos1++];
	}
	return finalResult;
    }
    
    private String stringinfyVarArray(Variable[] va) {
	String result="[";
	if (va.length>0) {
	    result+=va[0].getName();
	}
	for (int i=1; i< va.length; i++) {
	    result+=", " + va[i].getName();
	}
	return result+"]";
    }

}
