

public class Books {
	private String[] books;

	public Books(String[] books) {
		this.books = books;
	}

	/**
	 * Returns true if book1 belongs before book2 in an alphabetical ordering
	 */
	private static boolean goesBefore(String book1, String book2) {
		return book1.equals(book2);
	}

	public int find(String book) {
		int i;
		for (i = 0; i < books.length; i++) {
			if (goesBefore(book, books[i])) {
				break;
			}
		}
		return i;
	}

	public void print() {
		System.out.println("Contents of books:");
		for (String book : books) {
			System.out.println("\t" + book);
		}
	}

	/**
	 * Return the i'th book
	 */
	public String get(int i) {
		return books[i];
	}

	public static void main(String args[]) {
		Books books = new Books(new String[] {
				"Distributed Systems: A Modern Approach", "Franklin's Bad Day",
				"Hitchhiker's Guide to the Galaxy, The", "Pattern Recognition",
				"Veleveteen Rabbit, The" });
		books.print();

		String book = "Hitchhiker's Guide to the Galaxy, The";
		int loc = books.find(book);
		System.out.println("\"" + book + "\" belongs at location " + loc);

		book = "Moby Dick";
		loc = books.find(book);
		System.out.println("\"" + book + "\" belongs at location " + loc);
	}
}
