// sphere.h

#ifndef SPHERE_H
#define SPHERE_H

#include "coord.h"

/** Defines a sphere. The sphere is defined by its center coordinate and a radius. */
class Sphere {

private:
	Coord	center;
	double	radius;

public:
	
	/** Default constructor. Creates a sphere centered at (0,0,0) with radius of DEFAULT_SPHERE_RADIUS. */
	Sphere():radius(DEFAULT_SPHERE_RADIUS) {} 

	/** Constructor 
		\param center The center of the sphere
		\param radius The radius of the sphere
	*/
	Sphere(Coord center, double radius) {
		this->center = center;
		this->radius = radius;
	}

	/** Set the center 
		\param center The center of the sphere
	*/
	void setCenter(Coord center) { 
		this->center = center;
	}

	/** Set the radius 
		\param radius The radius of the sphere
	*/
	void setRadius(double radius) { 
		this->radius = radius;
	}

	/** Set parameters 
		\param center The center of the sphere
		\param radius The radius of the sphere
	*/
	void setParams(Coord center, double radius) { 
		this->center = center;
		this->radius = radius;
	}

	/** Get center of sphere 
		\param center \out The center of the sphere
	*/
	void getCenter(Coord& center) const { 
		center = this->center;
	}

	/** Get radius of the sphere 
		\param radius \out The radius of the sphere
	*/
	void getRadius(double& radius) const { 
		radius = this->radius;
	}

	/** Get parameters 
		\param center \out The center of the sphere
		\param radius \out The radius of the sphere
	*/
	void getParams(Coord& center, double& radius) const { 
		center = this->center;
		radius = this->radius;
	}

};

#endif