// line.h

#ifndef LINE_H
#define LINE_H

#include "coord.h"

/** Defines a 3D line segment. The segment is identified by two 3D coordinates, in the model coordinate system. */

class Line {

private:
	Coord coords[2];

public:
	
	/** Default constructor. Initializes the line from (0,0,0) to (0,0,0) */
	Line() {} 

	/** Constructor. Initializes the 2 coordinates of the line segments
		\param coord1 Coordinate of starting point of the line segments
		\param coord2 Coordinate of ending point of the line segments
	*/
	Line(Coord coord1, Coord coord2) {
		for (int i=0; i<3; i++) {
			coords[0][i] = coord1[i];
			coords[1][i] = coord2[i];
		}
	}

	/** Set the 2 coordinates of the line segments
		\param coords A 2-dimensional array holding the 2 line coordinates. If NULL, the line coordinates are not changed.
	*/
	void setCoords(const Coord* coords) { 
		if (coords==NULL) return;
		for (int i=0; i<3; i++) {
			this->coords[0][i] = coords[0][i];
			this->coords[1][i] = coords[1][i];
		}
	}

	/** Set the 2 coordinates of the line segments
		\param coords \out A 2-dimensional array which will hold the 2 line coordinates.
		\note \e coords has to allocated before use by the user
	*/
	void getCoords(Coord* coords)  { 
		if (coords==NULL) return;
		for (int i=0; i<3; i++) {
			coords[0][i] = this->coords[0][i];
			coords[1][i] = this->coords[1][i];
		}
	}
};

#endif