// info.h

#ifndef INFO_H
#define INFO_H

#include "linkedlist.cpp"
#include "vr.h"
#include "color.h"

class Info {
public:
	bool useDefaultColor;
	Color color;
	bool isEmpty;
	Info();
	Info(Info& info);
	Info& operator=(const Info &info);
};

class LineInfo:public Info {
public:
	double width;
	LineInfo();
	LineInfo(LineInfo& info);
	LineInfo& operator=(const LineInfo &info);
};

class VertexInfo:public Info {
public:
	LinkedList<EdgeID> *corners;
	double u, v;
	VertexInfo();
	~VertexInfo();
	VertexInfo(VertexInfo& info);
	VertexInfo& operator=(const VertexInfo &info);
};

typedef Info EdgeInfo;
typedef Info FaceInfo;
typedef Info SphereInfo;
typedef Info CylinderInfo;

#endif