// edge.h

#ifndef EDGE_H
#define EDGE_H

/** Defines an edge. The edge is defined by the two VertexID's of the two vertices of the edge. 
	The edge has no direction, so the order on the two VertexID's is random.
*/
class Edge {

private:
	VertexID v1, v2;

public:
	/** Constructor. Initializes the edge with the VertexID's
		\param v1 The VertexID of one of the edge's vertices
		\param v2 The VertexID of the second edge vertex
	*/
	Edge(VertexID v1 = -1, VertexID v2 = -1) { 
		this->v1 = v1;
		this->v2 = v2; 
	}
	/** Sets the VertexID's
		\param v1 The VertexID of one of the edge's vertices
		\param v2 The VertexID of the second edge vertex
	*/
	void set(VertexID v1, VertexID v2) { 
		this->v1 = v1;
		this->v2 = v2; 
	}
	/** Get the first VertexID
		\return The VertexID of the first vertex 
	*/
	VertexID getV1() {
		return v1;
	}
	/** Get the second VertexID
		\return The VertexID of the second vertex 
	*/
	VertexID getV2() {
		return v2;
	}
	/** Compares 2 Edges. Edges are the same if they have the same two VertexID's (not necessarily in the same order)
		\param edge The Edge to compare to
		\retval true The edges are the same
		\retval false The edges are different
	*/
	bool operator==(const Edge &edge) {
		if (edge.v1==v1 && edge.v2==v2) return true;
		if (edge.v1==v2 && edge.v2==v1) return true;
		return false;
	}
	/** Sets the edge according to \a edge
		\param edge The Edge to copy
	*/
	void operator=(const Edge &edge) {
		v1=edge.v1;
		v2=edge.v2;
	}
};

#endif