/******************************************************************************
		 BitMapImage.h: interface for the CBitMapImage class.


		Writen by:
				Gil Zigelman  *zgil@cs.technion.ac.il)

		Last updated:
		Dani Brunstein,		11/3/2001



		The CBitMapImage class provides interface for creating and accessing 
		bitmap image files. The following methods are available:

		Constructors:
					  

			CBitMapImage() 
			
				Initializes an empty bitmap.


		Destructor:
				
				  virtual ~CBitMapImage()


		Information methods:

				  void discrete()    
						
						changes the color to black and white
				
				  int GetWidth() const
				  
				  int GetHeight() const

				  int GetBitsSize() const 
			
				  int GetPixelSize() const 
			
				  const unsigned char* GetBitsPtr() 
				
						Returns the internal pointer to the bits pointer.
						Can be used for updating a device context with a bitmap
			
				
				  void GetRGB(int x, int y, unsigned char &valR, 
					          unsigned char &valG, unsigned char &valB) const

						Returns the red, green, blue values of the pixel located at (x,y)
						when (0,0) is the bottom-left corner of the image


				unsigned char* const GetRowPtr(int row)
				unsigned char* const GetRowPtr(int row) const
						
						Returns a pointer to row start in actul memory buffer


				const char* GetFileName()
						
  
		Modifying methods:
			
			
				void SetRGB(int x, int y, unsigned char valR, 
							unsigned char valG, unsigned char valB)

  						Updates the red, green, blue values of the pixel located at (x,y)
						when (0,0) is the bottom-left corner of the image
	  

				void Mirror()

						Mirrors the image
	
				
				void SetFileName(const char* filename)

						Updates the internal file name

		Save/Load methods:


			void SaveFile(const char* filename)
			void SaveFile()
			void LoadFile(const char* filename)

				When the file name is supplied, the internal file name is updated.
				When using SaveFile(), the file name must have been initialized earlier.


		Exceptions:


			When an internal error occurs, the methods throw a char* exception, which can 
			later be caught by the using application.

		
		Compilation
			
			The lib was compiled as (debug) multithreaded. Not as multithreaded dll!


********************************************************************************/

#ifndef _BITMAPIMAGE_
#define _BITMAPIMAGE_

#include <windows.h>
#include "params.h"
 
class CBitMapImage  
{
public:
	void Mirror();
	void discrete();
	int GetWidth() const { return width; } //width; }
	int GetHeight() const { return height; } //height;}
	int GetBitsSize() const { return bitsSize; }
	int GetPixelSize() const { return pixelSize; }
	const unsigned char* GetBitsPtr() const { return bits;}
	void GetRGB(int x, int y, unsigned char &valR, 
		unsigned char &valG, unsigned char &valB) const;
	void SetRGB(int x, int y, unsigned char valR, 
		unsigned char valG, unsigned char valB);
		// returns pointed to row start in actul memory buffer
	unsigned char* const GetRowPtr(int row); 
		// returns pointed to row start in actul memory buffer
	unsigned char* const GetRowPtr(int row) const; 
	unsigned char* const GetTextureColors();
	void cropTexture();
	void SaveFile(const char* filename);
	void SetFileName(const char* filename);
	void SaveFile();
	const char* GetFileName() { return fileName; }
	RESULT LoadFile(const char* filename);
	CBitMapImage();
	virtual ~CBitMapImage();

private:
	
	int bitsPerPixel;
	int memoryWidth;  // alligned to 32 bits width
	int pixelSize;
	bool allInformationWasReceived;
	int bitsSize;
	char *fileName;
	int height;
	int width;
	BITMAPINFO info;
	BITMAPFILEHEADER fileHeader;
	unsigned char* bits;
	unsigned char* texture_bits;

protected:
	void SetupFileHeader();
	void SetupInfo();
};


#endif // _BITMAPIMAGE_
