// MeshMakerView.h : interface of the CMeshMakerView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MESHMAKERVIEW_H__DA426675_B770_45E2_A2E4_7EA7849428B8__INCLUDED_)
#define AFX_MESHMAKERVIEW_H__DA426675_B770_45E2_A2E4_7EA7849428B8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "renderer.h"

extern Renderer *renderer;
extern Scenes *scenes;

class CMeshMakerView : public CView
{
protected: // create from serialization only
	CMeshMakerView();
	DECLARE_DYNCREATE(CMeshMakerView)

// Attributes
public:
	CMeshMakerDoc* GetDocument();
	void render();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMeshMakerView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMeshMakerView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	CClientDC* m_pDC;

	void InitGL();
	bool bSetupPixelFormat();
	void InitLight();
	//{{AFX_MSG(CMeshMakerView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnModelviewOrthographic();
	afx_msg void OnUpdateModelviewOrthographic(CCmdUI* pCmdUI);
	afx_msg void OnModelviewPerspective();
	afx_msg void OnUpdateModelviewPerspective(CCmdUI* pCmdUI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRenderingSolid();
	afx_msg void OnUpdateRenderingSolid(CCmdUI* pCmdUI);
	afx_msg void OnRenderingSolidwithwireframe();
	afx_msg void OnUpdateRenderingSolidwithwireframe(CCmdUI* pCmdUI);
	afx_msg void OnRenderingVertices();
	afx_msg void OnUpdateRenderingVertices(CCmdUI* pCmdUI);
	afx_msg void OnRenderingWireframe();
	afx_msg void OnUpdateRenderingWireframe(CCmdUI* pCmdUI);
	afx_msg void OnColorsBackground();
	afx_msg void OnColorsEdgesdefaultcolor();
	afx_msg void OnColorsFacesdefaultcolor();
	afx_msg void OnColorsVerticesdefaultcolor();
	afx_msg void OnModelviewBackface();
	afx_msg void OnUpdateModelviewBackface(CCmdUI* pCmdUI);
	afx_msg void OnColorsHighlightallvertices();
	afx_msg void OnColorsHighlightallfaces();
	afx_msg void OnColorsHighlightalledges();
	afx_msg void OnUpdateColorsHighlightalledges(CCmdUI* pCmdUI);
	afx_msg void OnUpdateColorsHighlightallfaces(CCmdUI* pCmdUI);
	afx_msg void OnUpdateColorsHighlightallvertices(CCmdUI* pCmdUI);
	afx_msg void OnRenderingShowlines();
	afx_msg void OnUpdateRenderingShowlines(CCmdUI* pCmdUI);
	afx_msg void OnPickFace();
	afx_msg LRESULT OnProjection(WPARAM wParam, LPARAM lParam);
	afx_msg void OnRenderingHighlightsonly();
	afx_msg void OnUpdateRenderingHighlightsonly(CCmdUI* pCmdUI);
	afx_msg LRESULT OnReset(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnRotate(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnScale(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnTranslate(WPARAM wParam, LPARAM lParam);
	afx_msg void OnModelviewReset();
	afx_msg void OnRenderingTexturemapping();
	afx_msg void OnUpdateRenderingTexturemapping(CCmdUI* pCmdUI);
	afx_msg void OnRenderingLoadtextureimage();
	afx_msg void OnRenderingShowcylinders();
	afx_msg void OnUpdateRenderingShowcylinders(CCmdUI* pCmdUI);
	afx_msg void OnRenderingShowspheres();
	afx_msg void OnUpdateRenderingShowspheres(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	int x, y;
	TRANSFORM_MODE transformMode;
};

#ifndef _DEBUG  // debug version in MeshMakerView.cpp
inline CMeshMakerDoc* CMeshMakerView::GetDocument()
   { return (CMeshMakerDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MESHMAKERVIEW_H__DA426675_B770_45E2_A2E4_7EA7849428B8__INCLUDED_)
