// MeshMakerView.cpp : implementation of the CMeshMakerView class
// 

#include "stdafx.h"
#include "MeshMaker.h"
#include "MeshMakerDoc.h"
#include "MeshMakerView.h"
#include "renderer.h"
#include "scene.h"

#include <gl/glaux.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CMeshMakerView* pView;

void refresh() {
	pView->InvalidateRect(NULL);
}

HWND getHWND() {
	return pView->m_hWnd;
}

RECT getClientRect() {
	RECT rect;
	pView->GetClientRect(&rect);
	return rect;
}


CWinThread* startNewThread(AFX_THREADPROC pfnThreadProc, LPVOID pParam) {
	return AfxBeginThread(pfnThreadProc, pParam);
}

/////////////////////////////////////////////////////////////////////////////
// CMeshMakerView

IMPLEMENT_DYNCREATE(CMeshMakerView, CView)

BEGIN_MESSAGE_MAP(CMeshMakerView, CView)
	//{{AFX_MSG_MAP(CMeshMakerView)
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_MODELVIEW_ORTHOGRAPHIC, OnModelviewOrthographic)
	ON_UPDATE_COMMAND_UI(ID_MODELVIEW_ORTHOGRAPHIC, OnUpdateModelviewOrthographic)
	ON_COMMAND(ID_MODELVIEW_PERSPECTIVE, OnModelviewPerspective)
	ON_UPDATE_COMMAND_UI(ID_MODELVIEW_PERSPECTIVE, OnUpdateModelviewPerspective)
	ON_WM_SIZE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_RENDERING_SOLID, OnRenderingSolid)
	ON_UPDATE_COMMAND_UI(ID_RENDERING_SOLID, OnUpdateRenderingSolid)
	ON_COMMAND(ID_RENDERING_SOLIDWITHWIREFRAME, OnRenderingSolidwithwireframe)
	ON_UPDATE_COMMAND_UI(ID_RENDERING_SOLIDWITHWIREFRAME, OnUpdateRenderingSolidwithwireframe)
	ON_COMMAND(ID_RENDERING_VERTICES, OnRenderingVertices)
	ON_UPDATE_COMMAND_UI(ID_RENDERING_VERTICES, OnUpdateRenderingVertices)
	ON_COMMAND(ID_RENDERING_WIREFRAME, OnRenderingWireframe)
	ON_UPDATE_COMMAND_UI(ID_RENDERING_WIREFRAME, OnUpdateRenderingWireframe)
	ON_COMMAND(ID_COLORS_BACKGROUND, OnColorsBackground)
	ON_COMMAND(ID_COLORS_EDGESDEFAULTCOLOR, OnColorsEdgesdefaultcolor)
	ON_COMMAND(ID_COLORS_FACESDEFAULTCOLOR, OnColorsFacesdefaultcolor)
	ON_COMMAND(ID_COLORS_VERTICESDEFAULTCOLOR, OnColorsVerticesdefaultcolor)
	ON_COMMAND(ID_MODELVIEW_BACKFACE, OnModelviewBackface)
	ON_UPDATE_COMMAND_UI(ID_MODELVIEW_BACKFACE, OnUpdateModelviewBackface)
	ON_COMMAND(ID_COLORS_HIGHLIGHTALLVERTICES, OnColorsHighlightallvertices)
	ON_COMMAND(ID_COLORS_HIGHLIGHTALLFACES, OnColorsHighlightallfaces)
	ON_COMMAND(ID_COLORS_HIGHLIGHTALLEDGES, OnColorsHighlightalledges)
	ON_UPDATE_COMMAND_UI(ID_COLORS_HIGHLIGHTALLEDGES, OnUpdateColorsHighlightalledges)
	ON_UPDATE_COMMAND_UI(ID_COLORS_HIGHLIGHTALLFACES, OnUpdateColorsHighlightallfaces)
	ON_UPDATE_COMMAND_UI(ID_COLORS_HIGHLIGHTALLVERTICES, OnUpdateColorsHighlightallvertices)
	ON_COMMAND(ID_RENDERING_SHOWLINES, OnRenderingShowlines)
	ON_UPDATE_COMMAND_UI(ID_RENDERING_SHOWLINES, OnUpdateRenderingShowlines)
	ON_COMMAND(ID_RENDERING_SHOWSPHERES, OnRenderingShowspheres)
	ON_UPDATE_COMMAND_UI(ID_RENDERING_SHOWSPHERES, OnUpdateRenderingShowspheres)
	ON_COMMAND(ID_RENDERING_SHOWCYLINDERS, OnRenderingShowcylinders)
	ON_UPDATE_COMMAND_UI(ID_RENDERING_SHOWCYLINDERS, OnUpdateRenderingShowcylinders)
	ON_MESSAGE(MESH_PROJECTION, OnProjection)
	ON_COMMAND(ID_RENDERING_HIGHLIGHTSONLY, OnRenderingHighlightsonly)
	ON_UPDATE_COMMAND_UI(ID_RENDERING_HIGHLIGHTSONLY, OnUpdateRenderingHighlightsonly)
	ON_MESSAGE(MESH_RESET, OnReset)
	ON_MESSAGE(MESH_ROTATE, OnRotate)
	ON_MESSAGE(MESH_SCALE, OnScale)
	ON_MESSAGE(MESH_TRANSLATE, OnTranslate)
	ON_COMMAND(ID_MODELVIEW_RESET, OnModelviewReset)
	ON_COMMAND(ID_RENDERING_TEXTUREMAPPING, OnRenderingTexturemapping)
	ON_UPDATE_COMMAND_UI(ID_RENDERING_TEXTUREMAPPING, OnUpdateRenderingTexturemapping)
	ON_COMMAND(ID_RENDERING_LOADTEXTUREIMAGE, OnRenderingLoadtextureimage)
	//}}AFX_MSG_MAP
	// Standard printing commands
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMeshMakerView construction/destruction

CMeshMakerView::CMeshMakerView()
{
	transformMode = NONE;
	pView = this;
}

CMeshMakerView::~CMeshMakerView()
{
}

BOOL CMeshMakerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMeshMakerView drawing

void CMeshMakerView::OnDraw(CDC* pDC)
{
	OnProjection(0, 0);
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

	render();
}

/////////////////////////////////////////////////////////////////////////////
// CMeshMakerView printing

BOOL CMeshMakerView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMeshMakerView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMeshMakerView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CMeshMakerView diagnostics

#ifdef _DEBUG
void CMeshMakerView::AssertValid() const
{
	CView::AssertValid();
}

void CMeshMakerView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMeshMakerDoc* CMeshMakerView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMeshMakerDoc)));
	return (CMeshMakerDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMeshMakerView message handlers

void CMeshMakerView::InitLight()
{
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	
	glLoadIdentity();
	
	int dir[] = { 1, 1, 1, 0};
	glLightiv(GL_LIGHT0, GL_POSITION, dir);
	float diffuse[] = { 1.0f, 1.0f, 1.0f, 1.0f };
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
	float ambient[] = {1.0f, 1.0f, 1.0f, 1.0f};
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
	glEnable(GL_LIGHT0);
	
	glEnable(GL_LIGHTING);
	
	glPopMatrix();

}

bool CMeshMakerView::bSetupPixelFormat()
{
	static PIXELFORMATDESCRIPTOR pfd =
	{
		sizeof(PIXELFORMATDESCRIPTOR),  // size of this pfd
		1,                              // version number
		PFD_DRAW_TO_WINDOW |            // support window
		  PFD_SUPPORT_OPENGL |          // support OpenGL
		  PFD_DOUBLEBUFFER,             // double buffered
		PFD_TYPE_RGBA,                  // RGBA type
		24,                             // 24-bit color depth
		0, 0, 0, 0, 0, 0,               // color bits ignored
		0,                              // no alpha buffer
		0,                              // shift bit ignored
		0,                              // no accumulation buffer
		0, 0, 0, 0,                     // accum bits ignored
		32,                             // 32-bit z-buffer
		0,                              // no stencil buffer
		0,                              // no auxiliary buffer
		PFD_MAIN_PLANE,                 // main layer
		0,                              // reserved
		0, 0, 0                         // layer masks ignored
	};
	int pixelformat;
	// Choose a pixel format that best matches that described in pfd
	if ( (pixelformat = ChoosePixelFormat(m_pDC->GetSafeHdc(), &pfd)) == 0 )
	{
		MessageBox("ChoosePixelFormat failed");
		return FALSE;
	}
	// Set the pixel format for the device xontext
	if (SetPixelFormat(m_pDC->GetSafeHdc(), pixelformat, &pfd) == FALSE)
	{
		MessageBox("SetPixelFormat failed");
		return FALSE;
	}

	return TRUE;
}

void CMeshMakerView::InitGL()
{
	PIXELFORMATDESCRIPTOR pfd;
	int         n;
	HGLRC       hrc;

    // store the DC
	m_pDC = new CClientDC(this);
	ASSERT(m_pDC != NULL);
	// Select the pixel format
	if (!bSetupPixelFormat()) return;

	n = ::GetPixelFormat(m_pDC->GetSafeHdc());
	::DescribePixelFormat(m_pDC->GetSafeHdc(), n, sizeof(pfd), &pfd);

	//CreateRGBPalette();

	// create the rendering context and make it current
	hrc = wglCreateContext(m_pDC->GetSafeHdc());
	wglMakeCurrent(m_pDC->GetSafeHdc(), hrc);

	//GetClientRect(&m_WndRect);
	glClearDepth(1.0f);
	glEnable(GL_DEPTH_TEST);

}

int CMeshMakerView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
    InitGL();
    InitLight();
	renderer = new Renderer();
	renderer->setMesh(((CMeshMakerDoc*)m_pDocument)->getMesh());
	((CMeshMakerDoc*)m_pDocument)->getMesh()->setRenderer(renderer);;
	scenes = new Scenes(((CMeshMakerDoc*)m_pDocument)->getMesh(), renderer);
	return 0;
}

BOOL CMeshMakerView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	
	return TRUE;
}

void CMeshMakerView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	renderer->reset();
}

void CMeshMakerView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	renderer->setSize(cx, cy);

	renderer->setProjection();
}


///////////////////////////////////////////////////////////////
//   Rendering

void CMeshMakerView::render()
{
	renderer->render();
	SwapBuffers(wglGetCurrentDC());

	ValidateRect(NULL);
}


///////////////////////////////////////////////////////////////
//   Rendering mode


void CMeshMakerView::OnRenderingSolid() 
{
	renderer->setRenderMode(SOLID);
}

void CMeshMakerView::OnRenderingSolidwithwireframe() 
{
	renderer->setRenderMode(SOLID_AND_WIREFRAME);
}

void CMeshMakerView::OnRenderingVertices() 
{
	renderer->setRenderMode(VERTICES);
}

void CMeshMakerView::OnRenderingWireframe() 
{
	renderer->setRenderMode(WIREFRAME);
}

void CMeshMakerView::OnRenderingHighlightsonly() 
{
	renderer->setRenderMode(HIGHLIGHT_ONLY);
}

void CMeshMakerView::OnUpdateRenderingSolid(CCmdUI* pCmdUI) 
{
	RENDER_MODE mode;
	renderer->getRenderMode(mode);
	pCmdUI->SetCheck(mode == SOLID);
	pCmdUI->Enable();
}

void CMeshMakerView::OnUpdateRenderingSolidwithwireframe(CCmdUI* pCmdUI) 
{
	RENDER_MODE mode;
	renderer->getRenderMode(mode);
	pCmdUI->SetCheck(mode == SOLID_AND_WIREFRAME);
	pCmdUI->Enable();
}

void CMeshMakerView::OnUpdateRenderingVertices(CCmdUI* pCmdUI) 
{
	RENDER_MODE mode;
	renderer->getRenderMode(mode);
	pCmdUI->SetCheck(mode == VERTICES);
	pCmdUI->Enable();
}

void CMeshMakerView::OnUpdateRenderingWireframe(CCmdUI* pCmdUI) 
{
	RENDER_MODE mode;
	renderer->getRenderMode(mode);
	pCmdUI->SetCheck(mode == WIREFRAME);
	pCmdUI->Enable();
}

void CMeshMakerView::OnUpdateRenderingHighlightsonly(CCmdUI* pCmdUI) 
{
	RENDER_MODE mode;
	renderer->getRenderMode(mode);
	pCmdUI->SetCheck(mode == HIGHLIGHT_ONLY);
	pCmdUI->Enable();
}


void CMeshMakerView::OnRenderingShowlines() 
{
	bool showLines;
	renderer->getLineDrawing(showLines);
	renderer->setLineDrawing(!showLines);
}

void CMeshMakerView::OnUpdateRenderingShowlines(CCmdUI* pCmdUI) 
{
	bool showLines;
	renderer->getLineDrawing(showLines);
	pCmdUI->SetCheck(showLines);
	pCmdUI->Enable();
}

void CMeshMakerView::OnRenderingShowcylinders() 
{
	bool showCylinders;
	renderer->getCylinderDrawing(showCylinders);
	renderer->setCylinderDrawing(!showCylinders);
}

void CMeshMakerView::OnUpdateRenderingShowcylinders(CCmdUI* pCmdUI) 
{
	bool showCylinders;
	renderer->getCylinderDrawing(showCylinders);
	pCmdUI->SetCheck(showCylinders);
	pCmdUI->Enable();
}

void CMeshMakerView::OnRenderingShowspheres() 
{
	bool showSpheres;
	renderer->getSphereDrawing(showSpheres);
	renderer->setSphereDrawing(!showSpheres);
}

void CMeshMakerView::OnUpdateRenderingShowspheres(CCmdUI* pCmdUI) 
{
	bool showSpheres;
	renderer->getSphereDrawing(showSpheres);
	pCmdUI->SetCheck(showSpheres);
	pCmdUI->Enable();
}

///////////////////////////////////////////////////////////////
//   Perspective / Orthographic view


void CMeshMakerView::OnModelviewOrthographic() 
{
	renderer->setPerspective( false);
}

void CMeshMakerView::OnModelviewPerspective() 
{
	renderer->setPerspective(true);
}

void CMeshMakerView::OnUpdateModelviewOrthographic(CCmdUI* pCmdUI) 
{
	bool perspective;
	renderer->getPerspective(perspective);
	pCmdUI->SetCheck(!perspective);
	pCmdUI->Enable();
}

void CMeshMakerView::OnUpdateModelviewPerspective(CCmdUI* pCmdUI) 
{
	bool perspective;
	renderer->getPerspective(perspective);
	pCmdUI->SetCheck(perspective);
	pCmdUI->Enable();
}

///////////////////////////////////////////////////////////////
//   Backface culling


void CMeshMakerView::OnModelviewBackface() 
{
	bool backFaceRemoval;
	renderer->getBackfaceCulling(backFaceRemoval);
	renderer->setBackfaceCulling(!backFaceRemoval);
}

void CMeshMakerView::OnUpdateModelviewBackface(CCmdUI* pCmdUI) 
{
	bool backFaceRemoval;
	renderer->getBackfaceCulling(backFaceRemoval);
	pCmdUI->SetCheck(backFaceRemoval);
	pCmdUI->Enable();
}

///////////////////////////////////////////////////////////////
//   Mouse interaction / transformations


void CMeshMakerView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if (!renderer->interactionEnabled) return;

	SetCapture();
	x = point.x;
	y = point.y;
	transformMode = (nFlags & MK_RBUTTON) ? TRANSLATE : ROTATE;

	SetCursor(AfxGetApp()->LoadStandardCursor((transformMode == TRANSLATE) ? IDC_SIZEALL : IDC_ARROW));
	if (renderer->inPickingMode) {
		
		GLuint selectBuf[512];
		GLint hits, viewport[4];
		glGetIntegerv(GL_VIEWPORT, viewport);
		
		float matrix[16];
		glGetFloatv(GL_MODELVIEW_MATRIX, matrix);
		glGetFloatv(GL_PROJECTION_MATRIX, matrix);

		glSelectBuffer(512, selectBuf);
		glRenderMode(GL_SELECT);
		
		glInitNames();
		glPushName(-1);
		
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPickMatrix((GLdouble)x, (GLdouble)(viewport[3]-y), 9.0, 9.0, viewport);

		renderer->setProjection();
		renderer->render(true); // wireframe/render, selection mode
		glFlush();
		
		hits = glRenderMode(GL_RENDER);

		renderer->processSelection(hits, selectBuf);
	}
}

void CMeshMakerView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	ReleaseCapture();
}

void CMeshMakerView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	SetCapture();
	x = point.x;
	y = point.y;
	transformMode = (nFlags & MK_LBUTTON) ? TRANSLATE : SCALE;

	SetCursor(AfxGetApp()->LoadStandardCursor((transformMode == TRANSLATE) ?
																						IDC_SIZEALL : IDC_SIZENS));
}

void CMeshMakerView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	ReleaseCapture();
}

void CMeshMakerView::OnMouseMove(UINT nFlags, CPoint point) 
{
	if(GetCapture() != this)
		return;

	float angle;
	int dx, dy;

	switch(transformMode) {
	case ROTATE:
		dx = (int)point.x - x;
		dy = (int)point.y - y;
		angle = (float)sqrt(dx * dx + dy * dy);
		renderer->screen_rotate(angle, dy, dx, 0);
		//renderer->screen_rotate((int)point.x - x, (int)point.y - y);
		break;

	case TRANSLATE:
		renderer->screen_translate((int)point.x - x, (int)point.y - y);
		break;

	case SCALE:
		renderer->screen_scale((int)point.y - y);
		break;
	}

	x = point.x;
	y = point.y;

}

LRESULT CMeshMakerView::OnRotate(WPARAM wParam, LPARAM lParam) {
	rotate_params *params = (rotate_params*)wParam;
	renderer->screen_rotate(params->angle, params->dx, params->dy, params->dz);
	delete params;
	return 1;
}

LRESULT CMeshMakerView::OnTranslate(WPARAM wParam, LPARAM lParam) {
	translate_params *params = (translate_params*)wParam;
	renderer->screen_translate(params->dx, params->dy, params->dz);
	delete params;
	return 1;
}

LRESULT CMeshMakerView::OnScale(WPARAM wParam, LPARAM lParam) {
	renderer->screen_scale((int)wParam);
	return 1;
}


///////////////////////////////////////////////////////////////
//   Colors


void CMeshMakerView::OnColorsBackground() 
{
	CColorDialog colorDlg;
	if (colorDlg.DoModal()==IDOK)
		renderer->setBgColor(colorDlg.GetColor());
}

void CMeshMakerView::OnColorsVerticesdefaultcolor() 
{
	CColorDialog colorDlg;
	if (colorDlg.DoModal()==IDOK)
		renderer->setVerticesDefaultColor(colorDlg.GetColor());
}

void CMeshMakerView::OnColorsEdgesdefaultcolor() 
{
	CColorDialog colorDlg;
	if (colorDlg.DoModal()==IDOK)
		renderer->setEdgesDefaultColor(colorDlg.GetColor());
}

void CMeshMakerView::OnColorsFacesdefaultcolor() 
{
	CColorDialog colorDlg;
	if (colorDlg.DoModal()==IDOK)
		renderer->setFacesDefaultColor(colorDlg.GetColor());
}


///////////////////////////////////////////////////////////////
//   Highlights


void CMeshMakerView::OnColorsHighlightallvertices() 
{	
	bool highlight;
	renderer->getHighlightAllVertices(highlight);
	renderer->highlightAllVertices(!highlight);
}

void CMeshMakerView::OnColorsHighlightalledges() 
{
	bool highlight;
	renderer->getHighlightAllEdges(highlight);
	renderer->highlightAllEdges(!highlight);
}

void CMeshMakerView::OnColorsHighlightallfaces() 
{
	bool highlight;
	renderer->getHighlightAllFaces(highlight);
	renderer->highlightAllFaces(!highlight);
}

void CMeshMakerView::OnUpdateColorsHighlightallvertices(CCmdUI* pCmdUI) 
{
	bool highlight;
	renderer->getHighlightAllVertices(highlight);
	pCmdUI->SetCheck(highlight);
	pCmdUI->Enable();
}

void CMeshMakerView::OnUpdateColorsHighlightalledges(CCmdUI* pCmdUI) 
{
	bool highlight;
	renderer->getHighlightAllEdges(highlight);
	pCmdUI->SetCheck(highlight);
	pCmdUI->Enable();
}

void CMeshMakerView::OnUpdateColorsHighlightallfaces(CCmdUI* pCmdUI) 
{
	bool highlight;
	renderer->getHighlightAllFaces(highlight);
	pCmdUI->SetCheck(highlight);
	pCmdUI->Enable();
}

///////////////////////////////////////////////////////////////
//   texture mapping


void CMeshMakerView::OnRenderingTexturemapping() 
{
	bool textureMapping;
	renderer->getTextureMapping(textureMapping);
	renderer->setTextureMapping(!textureMapping);
}

void CMeshMakerView::OnUpdateRenderingTexturemapping(CCmdUI* pCmdUI) 
{
	bool textureMapping;
	renderer->getTextureMapping(textureMapping);
	pCmdUI->SetCheck(textureMapping);
	pCmdUI->Enable();
}

///////////////////////////////////////////////////////////////
//   misc.


LRESULT CMeshMakerView::OnReset(WPARAM wParam, LPARAM lParam)
{
	renderer->reset();
	return 0;
}

LRESULT CMeshMakerView::OnProjection(WPARAM wParam, LPARAM lParam) {
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	renderer->setProjection();
	return 0;
}


void CMeshMakerView::OnModelviewReset() 
{
	renderer->resetModel();
	refresh();
}

void CMeshMakerView::OnRenderingLoadtextureimage() 
{
	CFileDialog dlg(TRUE);
	if (dlg.DoModal()==IDOK) {
		renderer->setTextureImage(dlg.GetPathName());
	}
}

