// MeshMakerDoc.cpp : implementation of the CMeshMakerDoc class
//

#include "stdafx.h"
#include "MeshMaker.h"

#include "MeshMakerDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
 
/////////////////////////////////////////////////////////////////////////////
// CMeshMakerDoc

IMPLEMENT_DYNCREATE(CMeshMakerDoc, CDocument)

BEGIN_MESSAGE_MAP(CMeshMakerDoc, CDocument)
	//{{AFX_MSG_MAP(CMeshMakerDoc)
	ON_COMMAND(ID_FILE_EXPORT_VRML, OnFileExportVrml)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMeshMakerDoc construction/destruction

CMeshMakerDoc::CMeshMakerDoc()
{
	mesh = new Mesh();
}

CMeshMakerDoc::~CMeshMakerDoc()
{
}

BOOL CMeshMakerDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	mesh->startNewModel();
	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CMeshMakerDoc serialization

void CMeshMakerDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMeshMakerDoc diagnostics

#ifdef _DEBUG
void CMeshMakerDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CMeshMakerDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMeshMakerDoc commands


BOOL CMeshMakerDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	mesh->openVRMLFile((char*)lpszPathName);

	return TRUE;
}

BOOL CMeshMakerDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
	mesh->saveVRMLFile((char*)lpszPathName);

	return TRUE;
}

void CMeshMakerDoc::OnFileExportVrml() 
{
	CFileDialog dlg(FALSE);
	if (dlg.DoModal()==IDOK) {
		mesh->VRMLExport(dlg.GetPathName());
	}
}

Mesh* CMeshMakerDoc::getMesh()
{
	return mesh;
}
