/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Board
extends JPanel
implements Runnable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private Image ball;
    private Image player1;
    private Image player2;
    private Image player3;
    private Thread animator;
    ArrayList<Ball> balls;
    Random rand = new Random();
    int width;
    int height;
    int mouseX;
    int mouseY;
    long cycle = 0L;
    long lastCycleChanged = 0L;
    boolean lastPlayerImage = true;
    double playerX;
    double playerY;
    boolean stop = true;
    boolean start = true;
    JLabel score = new JLabel();
    private final int DELAY = 30;

    public Board(int width, int height) {
        this.add(this.score);
        this.width = width;
        this.height = height;
        this.playerX = (double)width / 2.0 - 9.5;
        this.playerY = (double)height / 2.0 - 9.5;
        this.setBackground(Color.WHITE);
        this.setDoubleBuffered(true);
        ImageIcon ii = new ImageIcon(this.getClass().getResource("ball.png"));
        this.ball = ii.getImage();
        ii = new ImageIcon(this.getClass().getResource("player1.png"));
        this.player1 = ii.getImage();
        ii = new ImageIcon(this.getClass().getResource("player2.png"));
        this.player2 = ii.getImage();
        ii = new ImageIcon(this.getClass().getResource("player3.png"));
        this.player3 = ii.getImage();
        this.balls = new ArrayList(500);
        this.balls.add(new Ball(this.rand, width, height));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.animator = new Thread(this);
        this.animator.start();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.stop) {
            this.score.setText("Score: " + this.cycle / 10L);
        }
        Graphics2D g2d = (Graphics2D)g;
        for (Ball b : this.balls) {
            g2d.drawImage(this.ball, (int)b.x, (int)b.y, this);
        }
        boolean playerImage = this.lastPlayerImage;
        if (this.cycle - this.lastCycleChanged > 3L && this.rand.nextDouble() < 0.1) {
            boolean bl = playerImage = !this.lastPlayerImage;
        }
        if (this.stop && !this.start) {
            g2d.drawImage(this.player3, (int)this.playerX, (int)this.playerY, this);
        } else if (playerImage) {
            if (!this.lastPlayerImage) {
                this.lastCycleChanged = this.cycle;
            }
            g2d.drawImage(this.player1, (int)this.playerX, (int)this.playerY, this);
            this.lastPlayerImage = true;
        } else {
            if (this.lastPlayerImage) {
                this.lastCycleChanged = this.cycle;
            }
            g2d.drawImage(this.player2, (int)this.playerX, (int)this.playerY, this);
            this.lastPlayerImage = false;
        }
        Toolkit.getDefaultToolkit().sync();
        g.dispose();
    }

    public void cycle() {
        ++this.cycle;
        if (this.stop) {
            return;
        }
        double dx = (double)(this.mouseX - 14) - this.playerX;
        double dy = (double)(this.mouseY - 22) - this.playerY;
        double total = Math.abs(dx) + Math.abs(dy);
        if ((total *= total) > 0.3) {
            total = 0.3;
        }
        dx *= total;
        dy *= total;
        total = Math.abs(dx) + Math.abs(dy);
        if (total > 15.0) {
            total = 15.0 / total;
            dx *= total;
            dy *= total;
        }
        this.playerX += dx;
        this.playerY += dy;
        if (this.playerX < 0.0) {
            this.playerX = 0.0;
        }
        if (this.playerY < 20.0) {
            this.playerY = 20.0;
        }
        if (this.playerX > (double)(this.width - 20)) {
            this.playerX = this.width - 20;
        }
        if (this.playerY > (double)(this.height - 20)) {
            this.playerY = this.height - 20;
        }
        for (Ball b : this.balls) {
            double dis;
            b.x += b.dx;
            b.y += b.dy;
            if (b.y < 20.0) {
                b.dy = Math.abs(b.dy);
            }
            if (b.y > (double)(this.height - 22)) {
                b.dy = -Math.abs(b.dy);
            }
            if (b.x < 0.0) {
                b.dx = Math.abs(b.dx);
            }
            if (b.x > (double)(this.width - 21)) {
                b.dx = -Math.abs(b.dx);
            }
            if (!((dis = Math.sqrt((this.playerX + 9.5 - (b.x + 10.5)) * (this.playerX + 9.5 - (b.x + 10.5)) + (this.playerY + 9.5 - (b.y + 11.0)) * (this.playerY + 9.5 - (b.y + 11.0)))) <= 19.0)) continue;
            this.stop = true;
            break;
        }
        if (this.cycle % 100L == 0L) {
            this.balls.add(new Ball(this.rand, this.width, this.height));
        }
    }

    @Override
    public void run() {
        long beforeTime = System.currentTimeMillis();
        while (true) {
            this.cycle();
            this.repaint();
            long timeDiff = System.currentTimeMillis() - beforeTime;
            long sleep = 30L - timeDiff;
            if (sleep < 0L) {
                sleep = 2L;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                System.out.println("interrupted");
            }
            beforeTime = System.currentTimeMillis();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.stop = false;
        this.cycle = 0L;
        this.lastCycleChanged = 0L;
        this.balls.clear();
        this.start = false;
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
    }
}

